/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: BusStateDlg.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    Bus State Get/Set Test dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-04-29  Updated to latest cifXUser / stdint.h
    2006-07-04  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file BusStateDlg.h
///   Bus State Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"
#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////////////////
/// Bus State Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CBusStateDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CBusStateDlg)

public:
	CBusStateDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CBusStateDlg();

// Dialog Data
	enum { IDD = IDD_BUSSTATE };

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  uint32_t        m_ulSetTimeout;   //!< Timeout when calling Set Bus State
  CComboBox       m_cNewStateCtrl;  //!< Set Bus State Combobox Control

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();
};
